import { BrowserRouter,  Route, Routes } from 'react-router-dom'
import Layout from './layout/Layout'
import { ToastContainer } from 'react-toastify'

import './App.css'
import { useDispatch } from 'react-redux'
import { useEffect } from 'react'
import { matchSeriesList } from './redux/_reducers/_reducers'
import { BalanceProvider } from './global/socket'
import settings from './domainConfig'
import Register from './views/register/Register'







function setMultipleRootCssVariables(colors) {
  for (const [variable, value] of Object.entries(colors)) {
    document.documentElement.style.setProperty(variable, value);
  }
}

function App() {
  const dispatch = useDispatch();
  useEffect(() => {
    dispatch(
      matchSeriesList({
        limit: 100,
        pageno: 1,
        series_id: 0,
        type: "h",
      })
    );
    if (settings.title) {
      document.title = settings.title;
    }
    if (settings.favicon) {
      let link = document.querySelector("link[rel~='icon']");
      if (!link) {
        link = document.createElement("link");
        link.rel = "icon";
        document.head.appendChild(link);
      }
      link.href = settings.favicon;
    }
    if(settings.colors){
      setMultipleRootCssVariables(settings.colors)
    }
  }, [dispatch])



  return (
    <>
      <ToastContainer />
      <BalanceProvider>
        <BrowserRouter>
          <Routes>
            
     
            <Route path="*" element={<Layout />} />
            <Route path='/register/:refferId?' element={<Register />} />
          </Routes>
        </BrowserRouter>
      </BalanceProvider>
    </>
  );
}

export default App;
