import { useEffect, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { getBannerSlider, getCasinoList } from "../../redux/_reducers/_reducers";

function FeaturedGames() {

  const { getCasinoListData, bannerSliderData } = useSelector(state => state.authentication)
 

  const [newCasinoList, setNewCasinoList] = useState([])
  const [liveCasinoList, setLiveCasinoList] = useState([])
  const [popularCasinoList, setPopularCasinoList] = useState([])
  // const [bannerList, setBannerList] = useState([])

  const dispatch = useDispatch()

  useEffect(() => {
    const reqpayload = {
      limit: 100
    }
    dispatch(getCasinoList(reqpayload))
    dispatch(getBannerSlider())
  }, [])

  useEffect(() => {
    if (getCasinoListData) {
      setLiveCasinoList(getCasinoListData?.liveCasinoList ? getCasinoListData?.liveCasinoList : [])
      setNewCasinoList(getCasinoListData?.newCasinoList ? getCasinoListData?.newCasinoList : [])
      setPopularCasinoList(getCasinoListData?.popularCasinoList ? getCasinoListData?.popularCasinoList : [])
    }
  }, [getCasinoListData])



  return (
    <>
      <div className="mt-4 overflow-x-auto">
        <div className="border-l-4 border-[var(--light-header)]   px-2 text-gray-600 font-semibold my-2.5 lg:ml-0 ml-2">
          Live Casino Games
        </div>
        <div className="overflow-hidden">
          <div className="flex justify-between items-center gap-2 overflow-x-auto">
            {liveCasinoList?.map((game, index) => (
              <div onClick={() => { window.location.href = `/iframe-casino-new/${game.provider_name}/${game.game_id}` }} key={index} className="flex flex-col items-center justify-center md:w-[190px] sm:w-[172px] w-[205px] h-[155px]">
                <img src={game.Image} alt={game.game_name} className="transition-transform duration-300 ease-in transform scale-100 hover:scale-105 cursor-pointer md:w-[190px] sm:w-[172px] w-[205px] h-[120px]" />
                <span className="text-sm text-left py-1 px-2 bg-[var(--primary)]  text-white md:w-[190px] sm:w-[172px] w-[205px] h-[35px] text-nowrap">{game.game_name}</span>
              </div>
            ))}
          </div>
        </div>
      </div>
      <div className="mt-4 overflow-x-auto">
        <div className="border-l-4 border-[var(--light-header)]   px-2 text-gray-600 font-semibold my-2.5 lg:ml-0 ml-2">
          New Casino Games
        </div>
        <div className="overflow-hidden">
          <div className="flex justify-between items-center gap-2 overflow-x-auto">
            {newCasinoList?.map((game, index) => (
              <div onClick={() => { window.location.href = `/iframe-casino-new/${game.provider_name}/${game.game_id}` }} key={index} className="flex flex-col items-center justify-center md:w-[190px] sm:w-[172px] w-[205px] h-[155px]">
                <img src={game.Image} alt={game.game_name} className="transition-transform duration-300 ease-in transform scale-100 hover:scale-105 cursor-pointer md:w-[190px] sm:w-[172px] w-[205px] h-[120px]" />
                <span className="text-sm text-left py-1 px-2 bg-[var(--primary)]  text-white md:w-[190px] sm:w-[172px] w-[205px] h-[35px] text-nowrap">{game.game_name}</span>
              </div>
            ))}
          </div>
        </div>
      </div>
      <div className="mt-4 overflow-x-auto">
        <div className="border-l-4 border-[var(--light-header)]   px-2 text-gray-600 font-semibold my-2.5 lg:ml-0 ml-2">
          Popular Casino Games
        </div>
        <div className="overflow-hidden">
          <div className="flex justify-between items-center gap-2 overflow-x-auto">
            {popularCasinoList?.map((game, index) => (
              <div onClick={() => { window.location.href = `/iframe-casino-new/${game.provider_name}/${game.game_id}` }} key={index} className="flex flex-col items-center justify-center md:w-[190px] sm:w-[172px] w-[205px] h-[155px]">
                <img src={game.Image} alt={game.game_name} className="transition-transform duration-300 ease-in transform scale-100 hover:scale-105 cursor-pointer md:w-[190px] sm:w-[172px] w-[205px] h-[120px]" />
                <span className="text-sm text-left py-1 px-2 bg-[var(--primary)]  text-white md:w-[190px] sm:w-[172px] w-[205px] h-[35px] text-nowrap">{game.game_name}</span>
              </div>
            ))}
          </div>
        </div>
      </div>

      {bannerSliderData?.length > 0 && (
        <div className="mt-4 overflow-x-auto">
          <div className="border-l-4 border-[var(--light-header)]   px-2 text-gray-600 font-semibold my-2.5 lg:ml-0 ml-2">
            Banner
          </div>
          <div className="overflow-hidden">
            <div className="flex justify-start items-center gap-2 overflow-x-auto">
              {bannerSliderData?.map((game, index) => (
                <div onClick={() => { window.location.href = `/iframe-casino-new/${game.provider_name}/${game.game_id}` }} key={index} className="flex flex-col items-center justify-center md:w-[190px] sm:w-[172px] w-[205px] h-[155px]">
                  <img src={game.attachment} alt={game.title} className="transition-transform duration-300 ease-in transform scale-100 hover:scale-105 cursor-pointer md:w-[190px] sm:w-[172px] w-[205px] h-[120px]" />
                  <span className="text-sm text-left py-1 px-2 bg-[var(--primary)]  text-white md:w-[190px] sm:w-[172px] w-[205px] h-[35px] text-nowrap">{game.title}</span>
                </div>
              ))}
            </div>
          </div>
        </div>
      )}
    </>
  )
}

export default FeaturedGames
