import { useEffect, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { useNavigate } from "react-router-dom";
import { walletBalance } from "../../redux/_reducers/_reducers";
import { TfiReload } from "react-icons/tfi";

function MobileBalanceNotify() {
  const navigate = useNavigate()
  const dispatch = useDispatch()
  const [localStoragelogin, setlocalStorage] = useState(localStorage.getItem("token") ? true : false);
  const [isRotating, setIsRotating] = useState(false);
  const [balance, setBalance] = useState({
    coins: "",
    exposure: "",
    profitLoss: ""
  });
  const { defaultSettingData } = useSelector(state => state.authentication);
  const handleClick = () => {
    setIsRotating(true);
    setTimeout(() => {
      setIsRotating(false);
    }, 1000);
    dispatch(walletBalance())
  };

  useEffect(() => {
    setTimeout(() => {
      let Balance = JSON.parse(localStorage.getItem("clientBalance"));
      let Exposure = JSON.parse(localStorage.getItem("clientExposure"));
      
      const token = localStorage.getItem("token")
      setBalance({
        coins: Balance,
        exposure: Exposure,
      });
      if (token) {
        setlocalStorage(true)
      } else {
        setlocalStorage(false)
      }
    }, 1000);
  }, [balance]);
  return (
    <div>
      {defaultSettingData?.find(
        (data) => data?.key === "site.MESSAGE"
      )?.value && <div className="md:text-black text-white md:bg-transparent bg-[var(--primary)] flex justify-between items-center py-1.5">
          <div className="pl-1 pr-3 md:block hidden">
            <img src="/assets/dashboard/speaker.svg" alt="" className="w-6 h-6" />
          </div>
          <div className="pl-1 pr-3 md:hidden block">
            <img src="/assets/dashboard/index-announcement-iconwhite.svg" alt="" className="w-6 h-6" />
          </div>
          {<marquee className='text-[14px] flex-1'>
            {defaultSettingData?.find(
              (data) => data?.key === "site.MESSAGE"
            )?.value}
          </marquee>}
        </div>}
      {localStoragelogin && (
        <div className="bg-[var(--secondary)] p-3 md:rounded-md md:hidden block">
          <div className="flex justify-between items-center">
            <div className="flex justify-between items-center lg:w-1/5 gap-2">
              <div className="text-[15px] font-semibold">
                &#8377; {balance?.coins}
              </div>
              <div className="cursor-pointer" onClick={handleClick}>
                <TfiReload className={`transition-transform duration-1000 ${isRotating ? "rotate-animation" : ""}`} size={16} />
              </div>
            </div>
            <div className="flex-1 text-white text-end px-3 text-[15px] font-semibold">Expo: <span className="text-red-600">&#8377; {balance?.exposure}</span></div>
            <div className="border-l-[2px] border-[#8d8d8d]/30 pl-6 flex justify-start items-center text-[11px] space-x-3">
              <div
                onClick={() => { navigate('/withdrawal') }}
                className="flex flex-col items-center justify-center cursor-pointer">
                <img src="/assets/dashboard/icon-promotion.png" alt="" className="w-7 h-7" />
                <p className="text-white">Withdrawal</p>
              </div>
              <div
                onClick={() => { navigate('/deposit') }}
                className="flex flex-col items-center justify-center cursor-pointer">
                <img src="/assets/dashboard/icon-deposit.png" alt="" className="w-7 h-7" />
                <p className="text-white">Deposit</p>
              </div>
            </div>
          </div>
        </div>
      )}
    </div>
  )
}

export default MobileBalanceNotify
