/* eslint-disable react/prop-types */
import { useEffect, useRef } from "react";
import { useDispatch, useSelector } from "react-redux";
import { ourPagesShow } from "../../redux/_reducers/_reducers";


function Privacy({ activeSection, privacyClick }) {
    const dispatch = useDispatch()
    const { ourPagesShowData, loading } = useSelector(
        (state) => state.authentication
    );

    useEffect(() => {
        let payLoad = { "id": activeSection }
        dispatch(ourPagesShow(payLoad))
    }, [])
    const videoRef = useRef(null);

    useEffect(() => {

        if (videoRef.current) {
            videoRef.current.play();
        }
    }, []);

    return (

        <div className="privacy fixed block">
            <div className="privacy-start overflow-hidden">
                <div className="privacy-startcopy privacyModal px-4 !text-black">
                    {loading ? <div className="text-center flex justify-center items-center w-full h-full "> <video
                        ref={videoRef}
                        src="/loader.webm"
                        autoPlay
                        loop
                        muted
                        className="w-32 h-32"
                    ></video></div> : <div dangerouslySetInnerHTML={{ __html: ourPagesShowData?.body }} />}
                </div>
                <div className="privacy-start-ok ">
                    <button className="!bg-[var(--dark-header)]      text-white" onClick={privacyClick}>OK</button>
                </div>
            </div>
        </div >
    );
}

export default Privacy;
