import { useEffect, useState, useRef } from "react";
import { useDispatch, useSelector } from "react-redux";
import { RxCross2 } from "react-icons/rx";
import moment from "moment/moment";
import { userTurnover, userchatlist, depositRequest, customerDetails, getPromotionsOffer } from "../../redux/_reducers/_reducers";
import Loader from "../Loader/Loader";
import { Link } from "react-router-dom";
import wp from '/assets/whatsapplogo.png'
import { IoCopyOutline } from "react-icons/io5";
import { RiWhatsappLine } from "react-icons/ri";
import { toast } from "react-toastify";
import 'react-toastify/dist/ReactToastify.css';
import Withdrawal from "../../views/withdrawal/Withdrawal";
import Deposit from "../../views/deposit/Deposit";


function DepositWithdrawl({ handleClose }) {
    const [activeTab, setActiveTab] = useState("deposit");

    const handleDataFunc = (tab) => {
        setActiveTab(tab);
    };

    return (
        <>
            <div className=" w-lg mx-auto overflow-y-auto flex flex-col h-full text-whit">
                <div className="bg-[var(--primary)] md:rounded-tr-md md:rounded-tl-md sticky top-0 z-50">
                    <div className='flex justify-between text-white text-[19px] md:rounded-tr-md md:rounded-tl-md w-full items-center bg-[var(--primary)] pt-[12px] pb-1 px-2'>
                        <div></div>
                        Funds
                        <RxCross2 className='text-white cursor-pointer'
                            onClick={() => handleClose()}
                        />
                    </div>
                    <div className="!m-2 pb-1 bg-[var(--primary)] overflow-hidden ">
                        <div className="!my-2 w-full flex justify-between items-center text-white font-bold text-[13px]">
                            <div
                                onClick={() => handleDataFunc("deposit")}
                                className={`w-full p-[2px] text-center cursor-pointer transition-all duration-300  ${activeTab === "deposit" ? "text-white rounded !p-1 shadow shadow-black hover:text-[#ffe800] bg-[#2d9eff] " : "bg-[#004179]"
                                    }`}
                            >
                                Deposit
                            </div>
                            <div
                                onClick={() => handleDataFunc("withdrawal")}
                                className={`w-full p-[2px] text-center cursor-pointer transition-all duration-300  ${activeTab === "withdrawal" ? "text-white rounded !p-1 shadow shadow-black  hover:text-[#ffe800] bg-[#2d9eff] " : "bg-[#004179]"
                                    }`}
                            >
                                Withdrawal
                            </div>
                        </div>
                    </div>
                </div>
                <div className="text-sm font-medium text-center overflow-y-auto">
                    {activeTab === "deposit" ? (
                        <div className="">
                            <Deposit />
                        </div>
                    ) : (
                        <div className="">
                            <Withdrawal />
                        </div>
                    )}
                </div>
            </div>
        </>
    )
}

export default DepositWithdrawl;