import AOS from "aos";
import "aos/dist/aos.css";
import React, { useState, useEffect } from "react";
import { useNavigate } from "react-router-dom";


const MiniCasinoProvider = ({ setIsSideBar, isSideBar, isSidebarClose, providers, handleProviderClick }) => {

  useEffect(() => {
    AOS.init();
    AOS.refresh();
  }, [isSideBar]);

  if (isSidebarClose) return null


  return (
    <>
      <div
        className={` h-full bg-[#f9fcff] w-[100px] lg:hidden left-[190px] absolute transition-all duration-300 overflow-y-auto  ease-in-out z-30`}
        onClick={(e) => e.stopPropagation()}
        data-aos="fade-right" style={{ boxShadow: 'inset 1px 0px 15px [#e4e6e9]' }}>
        {providers?.map((game) => (
          <div
            key={game.eventId}
            onClick={() => handleProviderClick(game.provider_name)}
            className=" flex flex-col w-full border-b gap-2  items-center overflow-y-auto py-3">
            <img alt={game.provider_name} className="w-[30px] h-[30px]" src={game.image} />
            <p className="md:my-0 text-sm my-1 whitespace-nowrap">{game.provider_name}</p>
          </div>
        ))}
      </div>
    </>
  );
};

export default MiniCasinoProvider;