import { useEffect, useState } from "react"
import AppContent from "../component/layout/AppContent"
import AppFooter from "../component/layout/AppFooter"
import AppHeader from "../component/layout/AppHeader"
import AppSidebar from "../component/layout/AppSidebar"
import NotificationAlert from "../component/notificationAlert/NotificationAlert"
import Login from "../component/login/Login"





const Layout = () => {
    const [isSidebarClose, setIsSidebarClose] = useState(true);
    const [isNotification, setIsNotification] = useState(false);
    const [showLogin, setShowLogin] = useState(false);

    useEffect(() => {
        const checkSidebarStatus = () => {
            setIsSidebarClose(document.body.classList.contains("sidebar-collapse"));
        };
        checkSidebarStatus();
        const observer = new MutationObserver(checkSidebarStatus);
        observer.observe(document.body, { attributes: true });
        return () => observer.disconnect();
    }, []);
    useEffect(() => {
        const checkNtoficationStatus = () => {
            setIsNotification(document.body.classList.contains("login_notification"));
        };
        checkNtoficationStatus();
        const observer = new MutationObserver(checkNtoficationStatus);
        observer.observe(document.body, { attributes: true });
        return () => observer.disconnect();
    }, []);

    const handleLogin = () => {
        setShowLogin((prev) => !prev);
        if (isNotification) {
            setIsNotification((prev) => !prev);
        }
    };

    return (

        <div className='w-screen h-[92vh] lg:h-[100vh] flex overflow-hidden p-0 m-0'>
            {showLogin && (
                <div className=" fixed inset-0 backdrop-blur-[3px]  z-50 bg-transparent  flex justify-center items-center">
                    <div
                        onClick={(e) => e.stopPropagation()}
                        className=" animate-slideInFromBottom  !bg-white  w-full h-full md:max-w-[700px] md:w-[370px] md:h-[calc(100vh-16rem)]  border  text-black   rounded-md"
                    >
                        <Login handleLogin={handleLogin} />
                    </div>
                </div>
            )}
            {isNotification && (
                <div className="fixed inset-0 backdrop-blur-[3px] !z-50 bg-black bg-opacity-20 flex justify-center items-center">
                    <div
                        onClick={(e) => e.stopPropagation()}
                        className=" animate-slideInFromBottom  !bg-white relative  w-full  md:max-w-[700px] md:w-[370px]   border  text-black   rounded-md"
                    >
                        <NotificationAlert handleLogin={handleLogin} setShowLogin={setShowLogin} />
                    </div>
                </div>
            )}
            <div className={`w-0 ${isSidebarClose ? 'lg:w-[60px]' : "lg:w-[250px]"}  transition-all duration-[700ms] ease-in-out h-[92vh] lg:h-[100vh] overflow-hidden bg-[var(--primary)]   p-0 m-0  `} >
                <AppSidebar isSidebarClose={isSidebarClose} />
            </div>
            <div className={`w-full ${isSidebarClose ? 'lg:w-[calc(100vw-60px)]' : "lg:w-[calc(100vw-250px)]"} transition-all duration-[700ms]   h-[92vh] lg:h-[100vh] overflow-hidden  p-0 m-0`}>
                <div className="bg-[var(--primary)]  flex justify-center items-center h-[60px] lg:h-[60px] lg:px-4">
                    <AppHeader isSidebarClose={isSidebarClose} />
                </div>
                <div className="h-[calc(92vh-60px)] lg:h-[calc(100vh-60px)]  overflow-auto  pb-[52px] lg:pb-0" >
                    <AppContent />
                </div>
                <div className='h-[52px]  lg:h-[0px]  w-full fixed bottom-0   '>
                    <AppFooter />
                </div>
            </div>

        </div>

    )
}

export default Layout
