/** @type {import('tailwindcss').Config} */
export default {
  content: [
    "./index.html",
    "./src/**/*.{js,ts,jsx,tsx}",
  ],
  theme: {
    extend: {
      colors: {
        'matchLagai': '#72bbef',
        'matchKhai': '#FAA9BA',
        'successs' : "#64cc2f",
      },
      width: {
        'calc-custom': 'calc(100% - 452px)',
      },
      keyframes: {
        marquee: {
          '0%': { transform: 'translateY(100%)' },
          '100%': { transform: 'translateY(-100%)' },
        },
        slideInFromBottom: {
          '0%': { transform: 'translateY(100%)', opacity: '0' },
          '100%': { transform: 'translateY(0)', opacity: '1' },
        },
        slideOutToBottom: {
          '0%': { transform: 'translateY(0)', opacity: '1' },
          '100%': { transform: 'translateY(100%)', opacity: '0' },
        },
      },
      animation: {
        marquee: 'marquee 5s linear infinite',
        slideInFromBottom: 'slideInFromBottom 0.5s ease-out forwards',
        slideOutToBottom: 'slideOutToBottom 0.5s ease-in forwards',
      },
    },
  },
  plugins: [],
}
