import React, { useState, useEffect } from 'react';
import { BrowserRouter, Routes, Route, Navigate, Outlet } from 'react-router-dom';
import Layout from './components/Layout';
import Users from './components/Users';
import Settings from './components/Settings';
import AdminDashboard from './components/AdminDashboard';
import LoginPage from './components/Login';
import Wallet from './components/WalletUpdate';
import Deposit from './components/Deposit';
import Withdraw from './components/Withdraw';
import House from './components/House'
import History from './components/History';
import Game from './components/Games';
import GamesLog from './components/WinSetting';
import SEO from './components/SeoManager';
import Referal from './components/Refrel';
import Bonus from './components/Bonus';
import NotificationSettings from './components/NotificationSettings';
import WinSettings from './components/WinSetting';
import ClubMemberShip from './components/ClubMembership';
import Banner from './components/Banner';
import BankDetails from './components/BankDetails';
import { Buffer } from 'buffer';
import SportsBetting from './components/SportsBetting';
import RedeemCode from './components/RedeemCode';
import ExchangeRate from './components/ExchangeRate';
import Notification from './components/notification';
import SwapHistory from './components/SwapHistory';
import Reports from './components/Reports';
import KYC from './components/UserKyc';
import AdminManagementLayout from './components/AdminManagement';
import DashboardTab from './components/admin-management/DashboardTab';
import UserManagementTab from './components/admin-management/UserManagementTab';
import SettingsTab from './components/admin-management/SettingsTab';
import MyAccountTab from './components/admin-management/MyAccountTab';
import BetListTab from './components/admin-management/BetListTab';
import BetListLiveTab from './components/admin-management/BetListLiveTab';
import BankingTab from './components/admin-management/BankingTab';
import CasinoTab from './components/admin-management/CasinoTab';
import RiskManagementTab from './components/admin-management/RiskManagementTab';
import ImportTab from './components/admin-management/ImportTab';
import MessageTab from './components/admin-management/MessageTab';
import GameCenterTab from './components/admin-management/GameCenterTab';
import DepositSelf from './components/SelfDeposit';
import WithdrawSelf from './components/SelfWithdraw';
import GameWinLossToggle from './components/GameWinLossToggle';
import UserConfig from './components/UserConfig';
import SiteConfig from './components/SiteConfig';
import PercentageHierarchyPage from './components/PercentageHierarchyPage';
import MarketHistory from './components/MarketWins';
import FanWins from './components/FanwinsHistory';
import MarketInternalSettle from './components/MOsettle';
import FanInternalSettle from './components/FanmanualSettle';
import FancyResultNotShowingFromApi from './components/FancyResult';


function App() {
  window.Buffer = Buffer;
  const [token, setToken] = useState(localStorage.getItem('token'));

  useEffect(() => {
    const handleStorageChange = () => {
      setToken(localStorage.getItem('token'));
    };
    
    // Listen for changes in localStorage
    window.addEventListener('storage', handleStorageChange);
    
    // Initial check in case the value is set before the listener is attached
    handleStorageChange();

    return () => {
      window.removeEventListener('storage', handleStorageChange);
    };
  }, []);

  const ProtectedRoutes = () => {
    // Re-check token on each render of ProtectedRoutes
    const currentToken = localStorage.getItem('token');
    return currentToken ? <Outlet /> : <Navigate to="/login" replace />;
  };

  return (
    <BrowserRouter>
      <Routes>
        {/*  ───────── public page ───────── */}
        <Route path="/login" element={<LoginPage />} />

        {/*  ───────── protected part ────── */}
        <Route element={<ProtectedRoutes />}>
          <Route path="/" element={<Layout />}>

            {/* ↓↓↓  HOME = /admin-management  ↓↓↓ */}
            <Route index element={<Navigate to="/admin-management" replace />} />

            {/*  ───── separate top-level dashboard if you still need it ─────  */}
            <Route path="admin-dashboard" element={<AdminDashboard />} />

            {/*  ───── client-management group ─────  */}
            <Route path="admin-management" element={<AdminManagementLayout />}>
              <Route index       element={<DashboardTab />} />
              <Route path="dashboard" element={<DashboardTab />} />
              <Route path="user"      element={<UserManagementTab />} />
              <Route path="setting"   element={<SettingsTab />} />
              <Route path="myaccount" element={<MyAccountTab />} />
              <Route path="betlist"        element={<BetListTab />} />
              <Route path="betlistlive"    element={<BetListLiveTab />} />
              <Route path="banking"        element={<BankingTab />} />
              <Route path="casino"         element={<CasinoTab />} />
              <Route path="riskmanagement" element={<RiskManagementTab />} />
              <Route path="import"         element={<ImportTab />} />
              <Route path="message"        element={<MessageTab />} />
              <Route path="gamecenter"     element={<GameCenterTab />} />
            </Route>

            {/*  ───── everything else ─────  */}
            <Route path="withdraw"  element={<Withdraw />} />
            <Route path="users"     element={<Users />} />
            <Route path="settings"  element={<Settings />} />
            <Route path="deposit"   element={<Deposit />} />
            <Route path="depositself"   element={<DepositSelf />} />
            <Route path="withdrawself"  element={<WithdrawSelf />} />
            <Route path="games"     element={<Game/>} />
            <Route path="win-settings" element={<WinSettings/>} />
            <Route path="house"     element={<House />} />
            <Route path="wallet"    element={<Wallet />} />
            <Route path="history"   element={<History />} />
            <Route path="seo-manager" element={<SEO/>} />
            <Route path="affiliate" element={<Referal/>} />
            <Route path='marketwins'element={<MarketHistory/>}/>
              <Route path='MOsettle'element={<MarketInternalSettle/>}/>
               <Route path='Fansettle'element={<FanInternalSettle/>}/>
             <Route path='fancyreport'element={<FancyResultNotShowingFromApi/>}/>
            <Route path='fanwins'element={<FanWins/>}/>
            <Route path="bonus"     element={<Bonus/>}/>
            <Route path="club"      element={<ClubMemberShip/>}/>
            <Route path="banner"    element={<Banner/>}/>
            <Route path="bankdetails" element={<BankDetails/>}/>
            <Route path="redeemcode" element={<RedeemCode/>}/>
            <Route path="sportsbeting" element={<SportsBetting/>}/>
            <Route path="exchangerate" element={<ExchangeRate/>}/>
            <Route path="notification" element={<Notification/>}/>
            <Route path="swaphistory"  element={<SwapHistory/>}/>
            <Route path="reports"      element={<Reports/>}/>
            <Route path="kyc"          element={<KYC/>}/>
            <Route path="siteconfig"          element={<SiteConfig/>}/>
            <Route path="userconfig"          element={<UserConfig/>}/>
            <Route path="winloss"          element={<GameWinLossToggle/>}/>
            <Route path="notification-settings" element={<NotificationSettings/>} />
            <Route path="/percentage-hierarchy" element={<PercentageHierarchyPage />} />
          </Route>
        </Route>
      </Routes>
    </BrowserRouter>
  );
}

export default App;
